<?php
namespace Pawn;

use \lib\db as db;

class Model
{
	public $assoc = array();
	private $submit, $relation = array();
	
	public function __construct($data=array(), $submit=false)
	{
		foreach($data as $key=>$value)
		{
			$this->$key = $value;
		}
		
		$this->submit = $submit;
	}
	
	# Field values
	public function __get($key)
	{
		if(isset($this->assoc[$key]))
		{
			return $this->assoc[$key];
		}
		
		if(isset($this->assoc[$key.'_id']) && class_exists($class = '\\model\\'.$key))
		{
			if(!isset($this->relation[$key]))
			{
				$this->relation[$key] = call_user_func(array($class, 'get'), 'WHERE id=?', $this->{$key.'_id'}, false)->fetch();
			}
			
			return $this->relation[$key];
		}
		
		return null;
	}
	
	# Table name
	public static function table_name($class=null)
	{
		if($class === null)
		{
			$class = get_called_class();
		}
		
		return PREFIX.strtolower(substr($class, 6));
	}
	
	# Migration
	public static function migrate()
	{
		$model_name = substr(get_called_class(), 6);
		$table_name = static::table_name();
		
		if(!is_callable('static::migration'))
		{
			return;
		}
		
		$current = (int) db::execute('SELECT `version` FROM `'.PREFIX.'migration` WHERE `model`="'.$model_name.'"')->fetchColumn();
		
		$full = static::migration($model_name, $current);
		
		if(!$full)
		{
			return;
		}
		
		$total = count($full);
		
		if($total > $current)
		{
			$migration = array_slice($full, $current);
			
			foreach($migration as $action)
			{
				switch($action[0])
				{
					case 'CREATE':
						foreach($action[1] as $name=>&$field)
						{
							$field = '`'.$name.'` '.$field;
						}
						
						if(!isset($action[2]) || $action[2] !== false)
						{
							$action[1] = array_merge(array
							(
								'id INT UNSIGNED PRIMARY KEY AUTO_INCREMENT',
								'trash TINYINT',
								'ts_create INT UNSIGNED',
								'ts_edit INT UNSIGNED'
							), $action[1]);
						}
						
						db::execute('CREATE TABLE IF NOT EXISTS `'.$table_name.'` ('.implode(',', $action[1]).')', true);
					break;
					case 'POPULATE':
						$time = false;
						$columns = $full[0][1];
						
						if(!isset($full[0][2]) || $full[0][2] !== false)
						{
							$time = time();
							
							$columns['trash'] = null;
							$columns['ts_edit'] = null;
							$columns['ts_create'] = null;
						}
						
						$query = 'INSERT INTO `'.$table_name.'` (`'.implode('`,`', array_keys($columns)).'`) VALUES';
						
						foreach($action[1] as $i=>$row)
						{
							if($i)
							{
								$query .= ',';
							}
							
							$query .= ' (';
							
							if($time)
							{
								$row[] = 0;
								$row[] = $time;
								$row[] = $time;
							}
							
							foreach($row as $j=>$value)
							{
								if($j)
								{
									$query .= ', ';
								}
								
								$query .= db::quote($value);
							}
							
							$query .= ')';
						}
						
						db::execute($query);
					break;
					case 'CONFIG':
						foreach($action[1] as $key=>$value)
						{
							db::query('INSERT INTO `'.PREFIX.'config` VALUES (?, ?)', array($model_name.'.'.$key, $value));
						}
					break;
					case 'ADD':
						foreach($action[1] as $name=>$type)
						{
							db::execute('ALTER TABLE `'.$table_name.'` ADD `'.$name.'` '.$type, true);
						}
					break;
					case 'REMOVE':
						foreach($action[1] as $name)
						{
							db::execute('ALTER TABLE `'.$table_name.'` DROP COLUMN `'.$name.'`', true);
						}
					break;
					case 'MODIFY':
						foreach($action[1] as $name=>$type)
						{
							db::execute('ALTER TABLE `'.$table_name.'` MODIFY `'.$name.'` '.$type, true);
						}
					break;
					case 'QUERY':
						db::execute($action[1]);
					break;
				}
			}
		}
		
		if(!$current)
		{
			db::execute('INSERT INTO `'.PREFIX.'migration` VALUES ("'.$model_name.'", '.$total.')');
		} else
		{
			db::execute('UPDATE `'.PREFIX.'migration` SET `version`='.$total.' WHERE `model`="'.$model_name.'"');
		}
	}
	
	# Create
	public function create($name='instance', $preset='default')
	{
		$form = new \lib\Form($name, $preset, $this->submit);
		
		$fields = array();
		$columns = $this->columns($preset, 'create', $form, $this);
		
		foreach($columns as $name=>$field)
		{
			if($this->$name !== null)
			{
				$field[2] = $this->$name;
			}
			
			call_user_func_array(array($form, 'field'), array_merge((array) $name, $field));
			
			$fields[$name] = $form->fields[$name]->value;
		}
		
		if($this->submit)
		{
			$form->submitted = true;
		}
		
		if($form->validate())
		{
			if(method_exists($this, 'fields'))
			{
				$fields = $this->fields('create', $fields, $preset);
				
				if(!$fields)
				{
					$form->valid = false;
					
					return $form;
				}
			}
			
			$fields['trash'] = 0;
			$fields['ts_create'] = $fields['ts_edit'] = time();
			
			$keys = array_keys($fields);
			
			db::query('INSERT INTO `'.static::table_name().'` (`'.implode('`, `', $keys).'`)  VALUES (:'.implode(', :', $keys).')', $fields);
			
			$row = db::query('SELECT * FROM `'.static::table_name().'` WHERE id=?', db::last_id())->fetch(\PDO::FETCH_ASSOC);
			
			foreach($row as $key=>$value)
			{
				if(isset($form->fields[$key]) && $form->fields[$key]->type == 'file')
				{
					$this->assoc[$key] = $form->fields[$key]->save($this);
				} else
				{
					$this->assoc[$key] = $value;
				}
			}
			
			if($preset == 'administrate' && get_class($this) != 'model\\Home' && get_class($this) != 'model\\Trash')
			{
				$action = new \model\Home(array
				(
					'action'	=>	'create',
					'model'		=>	$this
				), true);
				
				$action->create();
			}
		}
		
		return $form;
	}
	
	# Edit
	public function edit($name='instance', $preset='default')
	{
		$form = new \lib\Form($name, $preset, $this->submit);
		
		$fields = array();
		$columns = $this->columns($preset, 'edit', $form);
		
		foreach($columns as $name=>$field)
		{
			if($this->$name !== null && $field[0] != 'password')
			{
				$field[2] = $this->$name;
			}
			
			call_user_func_array(array($form, 'field'), array_merge((array) $name, $field));
			
			$fields[$name] = $form->fields[$name]->value;
		}
		
		if($form->validate())
		{
			if(method_exists($this, 'fields'))
			{
				$fields = $this->fields('edit', $fields, $preset);
			}
			
			foreach($fields as $key=>$value)
			{
				if(isset($form->fields[$key]) && $form->fields[$key]->type == 'file')
				{
					
					$value = $form->fields[$key]->save($this);
				}
				
				$this->$key = $value;
			}
			
			if($preset == 'administrate')
			{
				$this->ts_edit = time();
				
				$action = new \model\Home(array
				(
					'action'	=>	'edit',
					'model'		=>	$this
				), true);
				
				$action->create();
			}
		}
		
		return $form;
	}
	
	# Get
	public static function get($query=null, $data=array(), $trash=0, $call=null)
	{
		$class_name = get_called_class();
		
		if($trash !== false && strtoupper(substr($query, 0, 5)) == 'WHERE')
		{
			$query = 'AND'.substr($query, 5);
		}
		
		$sth = db::query('SELECT * FROM `'.static::table_name().'` '.(($trash === false)?'':'WHERE trash='.$trash.' ').$query, (array) $data);
		$sth->setFetchMode(\PDO::FETCH_CLASS, $class_name);
		
		if($call !== null)
		{
			$rows = $sth->fetchAll();
			
			foreach($rows as $row)
			{
				$row->$call();
			}
			
			return $rows;
		}
		
		return $sth;
	}
	
	# Count
	public static function num_rows($query=null, $data=array(), $trash=0)
	{
		if($trash !== false && strtoupper(substr($query, 0, 5)) == 'WHERE')
		{
			$query = 'AND'.substr($query, 5);
		}
		
		return (int) db::query('SELECT COUNT(*) FROM `'.static::table_name().'` '.(($trash === false)?'':'WHERE trash='.$trash.' ').$query, (array) $data)->fetchColumn();
	}
	
	# Insert
	public static function insert($row)
	{
		$time = time();
		
		$row['trash'] = 0;
		$row['ts_edit'] = $time;
		$row['ts_create'] = $time;
		
		$keys = array_keys($row);
		
		return db::query('INSERT INTO `'.static::table_name().'` (`'.implode('`, `', $keys).'`)  VALUES (:'.implode(', :', $keys).')', $row);
	}
	
	# Trash
	public function trash()
	{
		$this->trash = 1;
		
		$trash = new \model\Trash(array
		(
			'model'		=>	$this
		), true);
		
		$trash->create();
		
		$action = new \model\Home(array
		(
			'action'	=>	'trash',
			'model'		=>	$this
		), true);
		
		$action->create();
	}
	
	# Restore
	public function restore()
	{
		$this->trash = 0;
	}
	
	# Delete
	public function delete()
	{
		$files = glob(ROOT.'public/db/'.strtolower(substr(get_class($this), 6)).'/*/'.$this->id.'.*');
		
		foreach($files as $file)
		{
			unlink($file);
		}
		
		db::query('DELETE FROM `'.static::table_name().'` WHERE id=?', $this->id);
	}
	
	# Update
	public function __set($key, $value)
	{
		if(isset($this->assoc[$key]) && $this->id)
		{
			db::query('UPDATE `'.static::table_name().'` SET `'.$key.'`=? WHERE id=?', array($value, $this->id));
		}
		
		$this->assoc[$key] = $value;
	}
	
	# Date-time format
	protected function datetime($time)
	{
		return '<span title="'.\lib\Lang::get('time', array('time'=>date('H:i'))).'">'.\Pawn::get_date($time).'</span>';
	}
	
	# File
	public function file($field, $default='')
	{
		if(substr($this->$field, 0, 7) == 'http://' || substr($this->$field, 0, 8) == 'https://')
		{
			return $this->$field;
		} else
		{
			$host = 'public/db/'.strtolower(substr(get_class($this), 6)).'/'.$field.'/'.$this->$field;
			
			if(file_exists(ROOT.$host))
			{
				return WEB.'/'.$host.'?'.filemtime(ROOT.$host);
			}
			
			return WEB.'/public/'.$default;
		}
	}
	
	public function filePath($field)
	{
		$path = ROOT.'public/db/';
		
		$path .= strtolower(substr(get_class($this), 6)).'/';
		
		if(!is_dir($path))
		{
			mkdir($path);
		}
		
		$path .= $field.'/';
		
		if(!is_dir($path))
		{
			mkdir($path);
		}
		
		return $path;
	}
	
	# Fields
	protected function allow_fields($fields, $keys)
	{
		$row = array();
		
		foreach($keys as $key)
		{
			if(isset($fields[$key]))
			{
				$row[$key] = $fields[$key];
			} else
			{
				$row[$key] = '';
			}
		}
		
		return $row;
	}
	
	# Image-enabled
	protected function img_enabled($enabled)
	{
		return $enabled?array('<img alt="'.($enabled?1:0).'" src="'.WEB.'/fw/public/pawn/image/enabled.png"/>'):'';
	}
}